% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareParameters4.R
\name{prepareParameters4}
\alias{prepareParameters4}
\title{prepareParameters4}
\usage{
prepareParameters4(function.name, karyoplot, data=NULL, chr=NULL, x0=NULL, x1=NULL, y0=NULL, y1=NULL, ymax=NULL, ymin=NULL, r0=NULL, r1=NULL, data.panel=1, filter.data=TRUE, ...)
}
\arguments{
\item{function.name}{(character) The name of the function calling \code{prepareParameters4}. Only user for error reporting.}

\item{karyoplot}{(KaryoPlot) A karyoplot object.}

\item{data}{A GRanges}

\item{chr}{A character representing the chromosome names.}

\item{x0}{The position in the chromosome in number of bases.}

\item{x1}{The position in the chromosome in number of bases.}

\item{y0}{The value to be plotted.}

\item{y1}{The value to be plotted.}

\item{ymax}{The maximum value of y}

\item{ymin}{The minimum value of y}

\item{r0}{The start of the range to use for plotting}

\item{r1}{The end of the range to use for plotting}

\item{data.panel}{The data panel to use}

\item{filter.data}{A boolean indicating if data should be filtered so only data in visible chromosomes is kept. (defaults to TRUE, filter data)}

\item{...}{Any additional parameter}
}
\value{
A list with five values: \code{chr}, \code{x0}, \code{x1}, \code{y0} and \code{y1}. Each of them 
a vector of the same length with the normalized values to plot.
}
\description{
Prepare and normalize the parameters for functions with x0, x1 and y0, y1 parameters
}
\details{
This function prepares and normalizes the parameters for plotting functions  
with x0, x1, y0 and y1 parameters (as opposed to x and y) so functions can
offer a richer interface while internally dealing only with standard and 
simple code. It extracts the 
positions from \code{data} if available and applies the \code{r0} and 
\code{r1} scaling. It returns the ready to plot values in a list with
only \code{chr}, \code{x0}, \code{x1}, \code{y0} and \code{y1}. 
Individual parameters (\code{chr}, \code{x0}, \code{x1}, \code{y0} and 
All parameters are interpreted and used as explained in \code{\link{kpRect}}.
It also filters out any data points corresponding to chromosomes not present
in the current karyoplot.
}
\note{
This function is only useful when creating custom plotting functions. 
It is not intended to the general user.

For detailed documentation on the parameters, see \code{\link{kpRect}}
}
\examples{

kp <- plotKaryotype()
prepareParameters4("TestFunc", kp, data=NULL, chr="chr1", x0=c(10, 20, 30), x1=c(20, 30, 40), y0=c(0, 1, 2), y1=c(0.5, 1.5, 3), r0=0, r1=0.5, ymin=0, ymax=3)

 
}
\seealso{
\code{\link{kpRect}}
}
