% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotRainfall.R
\name{kpPlotRainfall}
\alias{kpPlotRainfall}
\title{kpPlotRainfall}
\usage{
kpPlotRainfall(karyoplot, data, ref=NULL, alt=NULL, col="cell21breast", ymin=NULL, ymax=7, data.panel=1, r0=NULL, r1=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}, a \code{VRanges} or a path to a VCF file) A GRanges or VRanges object with the variants to plot or the path to a VCF file.}

\item{ref}{(character vector or NULL) A character vector of with the reference base of the variants in data. Used to determine the color. If NULL and data is a VRanges or a VCF file, the information in data will be used (defaults to NULL)}

\item{alt}{(character vector or NULL) A character vector of with the alternative base of the variants in data. Used to determine the color. If NULL and data is a VRanges or a VCF file, the information in data will be used (defaults to NULL)}

\item{col}{(a color vector, a color table or a color schema) The colors to use to draw the points. If the length of the vector is lower than the length of data, it will be recycled. Color table and color schema must be compatible with getVariantColors. If NULL, points will be plotted in black. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value to be plotted on the data panel. If NULL, it is set to 0. (deafults to NULL)}

\item{ymax}{(numeric) The maximum value to be plotted on the data.panel. (defaults to 7, (equivalent to 10Mb between consecutive features))}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions. In particular \code{col} and \code{border} can be used to set the colors used.}
}
\value{
Returns the original karyoplot object with the data computed (distances) stored at \code{karyoplot$latest.plot}
}
\description{
Creates a rainfall plot showing the distances between features in the genome.
Usually used to plot the distance bewteen somatic mutations to idenify kataegis.
}
\details{
\code{kpPlotRainfall} plots the distances between a feature and the next one
in a log scale along the genome. It is usually used to plot the distance 
between somatic mutations in order to identify regions with an accumulation 
of close mutations.

There's more information at the \url{https://bernatgel.github.io/karyoploter_tutorial/}{karyoploteR tutorial}.
}
\examples{

set.seed(1000)

data <- createRandomRegions(nregions=2000)
 
kp <- plotKaryotype("hg19", plot.type=4)
kp <- kpPlotRainfall(kp, data)
kpAxis(kp, ymax=7, tick.pos=c(0:7))
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpPlotDensity}}, \code{\link{kpPlotCoverage}}
}
