% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_granges_string}
\alias{get_granges_string}
\title{GRanges to region strings}
\usage{
get_granges_string(gr)
}
\arguments{
\item{gr}{A GRanges object}
}
\value{
A character vector
}
\description{
Coerces GenomicRanges to \code{chr:start-end} strings with \code{as.character}. If any
regions have the same start and end, \code{as.character} returns \code{chr:start}
strings which are invalid for the htslib API. These are corrected to
\code{chr:start-start}.
}
\examples{
if (requireNamespace("GenomicRanges", quietly = TRUE)) {
  get_granges_string(GenomicRanges::GRanges(c("chr1:1-10", "chr2:15-20")))
}
}
