% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV_tumor_subclusters.R
\name{plot_subclusters}
\alias{plot_subclusters}
\title{Plot a heatmap of the data in the infercnv object with the subclusters being displayed as annotations.}
\usage{
plot_subclusters(
  infercnv_obj,
  out_dir,
  output_filename = "subcluster_as_annotations"
)
}
\arguments{
\item{infercnv_obj}{infercnv object}

\item{out_dir}{Directory in which to output.}

\item{output_filename}{Filename to save the figure to.}
}
\value{
infercnv_obj the modified infercnv object that was plotted where subclusters are assigned as annotation groups
}
\description{
Formats the data and sends it for plotting.
}
\examples{
# data(infercnv_data_example)
# data(infercnv_annots_example)
# data(infercnv_genes_example)

# infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
#                                                           gene_order_file=infercnv_genes_example,
#                                                           annotations_file=infercnv_annots_example,
#                                                           ref_group_names=c("normal"))

# infercnv_object_example <- infercnv::run(infercnv_object_example,
#                                          cutoff=1,
#                                          out_dir=tempfile(), 
#                                          cluster_by_groups=TRUE, 
#                                          denoise=TRUE,
#                                          HMM=FALSE,
#                                          num_threads=2,
#                                          no_plot=TRUE)

data(infercnv_object_example)

plot_subclusters(infercnv_object_example,
                 out_dir=tempfile(),
                 output_filename="subclusters_as_annotations"
                 )

}
