% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV_BayesNet.R
\name{inferCNVBayesNet}
\alias{inferCNVBayesNet}
\title{inferCNVBayesNet: Run Bayesian Network Mixture Model To Obtain Posterior Probabilities For HMM Predicted States}
\usage{
inferCNVBayesNet(
  file_dir,
  infercnv_obj,
  HMM_states,
  out_dir,
  resume_file_token,
  model_file = NULL,
  CORES = 1,
  postMcmcMethod = NULL,
  plotingProbs = TRUE,
  quietly = TRUE,
  diagnostics = FALSE,
  HMM_type = HMM_type,
  k_obs_groups = k_obs_groups,
  cluster_by_groups = cluster_by_groups,
  reassignCNVs = TRUE,
  no_plot = no_plot,
  useRaster
)
}
\arguments{
\item{file_dir}{Location of the directory of the inferCNV outputs.}

\item{infercnv_obj}{InferCNV object.}

\item{HMM_states}{InferCNV object with HMM states in expression data.}

\item{out_dir}{(string) Path to where the output file should be saved to.}

\item{resume_file_token}{(string) String token that contains some info on settings used to name files.}

\item{model_file}{Path to the BUGS Model file.}

\item{CORES}{Option to run parallel by specifying the number of cores to be used. (Default: 1)}

\item{postMcmcMethod}{What actions to take after finishing the MCMC.}

\item{plotingProbs}{Option for adding plots of Cell and CNV probabilities. (Default: TRUE)}

\item{quietly}{Option to print descriptions along each step. (Default: TRUE)}

\item{diagnostics}{Option to plot Diagnostic plots and tables. (Default: FALSE)}

\item{HMM_type}{The type of HMM that was ra, either 'i3' or 'i6'. Determines how many state were predicted by the HMM.}

\item{k_obs_groups}{Number of groups in which to break the observations. (default: 1)}

\item{cluster_by_groups}{If observations are defined according to groups (ie. patients), each group
of cells will be clustered separately. (default=FALSE, instead will use k_obs_groups setting)}

\item{reassignCNVs}{(boolean) Given the CNV associated probability of belonging to each possible state, 
reassign the state assignments made by the HMM to the state that has the highest probability. (default: TRUE)}

\item{no_plot}{(boolean) Option set by infercnv::run() for producing visualizations.}

\item{useRaster}{Option to use rasterization when plotting}
}
\value{
Returns a MCMC_inferCNV_obj and posterior probability of being in one of six Copy Number Variation states
(states: 0, 0.5, 1, 1.5, 2, 3) for CNV's identified by inferCNV's HMM.
}
\description{
Uses Markov Chain Monte Carlo (MCMC) and Gibbs sampling to estimate the posterior
probability of being in one of six Copy Number Variation states (states: 0, 0.5, 1, 1.5, 2, 3) for CNV's identified by
inferCNV's HMM. Posterior probabilities are found for the entire CNV cluster and each individual
cell line in the CNV.
}
\examples{
data(infercnv_data_example)
data(infercnv_annots_example)
data(infercnv_genes_example)
data(HMM_states)

infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
                                                          gene_order_file=infercnv_genes_example,
                                                          annotations_file=infercnv_annots_example,
                                                          ref_group_names=c("normal"))
          
out_dir = tempfile()
infercnv_object_example <- infercnv::run(infercnv_object_example,
                                         cutoff=1,
                                         out_dir=out_dir, 
                                         cluster_by_groups=TRUE,
                                         analysis_mode="samples",
                                         denoise=TRUE,
                                         HMM=TRUE,
                                         num_threads=2,
                                         no_plot=TRUE)
mcmc_obj <- infercnv::inferCNVBayesNet(infercnv_obj      = infercnv_object_example,
                                       HMM_states        = HMM_states,
                                       file_dir          = out_dir,
                                       postMcmcMethod    = "removeCNV",
                                       out_dir           = out_dir,
                                       resume_file_token = "HMMi6.hmm_mode-samples",
                                       quietly           = TRUE,
                                       CORES             = 2,
                                       plotingProbs      = FALSE,
                                       diagnostics       = FALSE,
                                       HMM_type          = 'i6',
                                       k_obs_groups      = 1,
                                       cluster_by_groups = FALSE,
                                       reassignCNVs      = FALSE,
                                       no_plot           = TRUE)
                              
}
