% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeImmunogen.R
\name{removeImmunogen}
\alias{removeImmunogen}
\title{Remove an existing immunogen}
\usage{
removeImmunogen(proteinDF, name)
}
\arguments{
\item{proteinDF}{Protein DataFrame created by call to getProteinFeatures()}

\item{name}{String, name of immunogen}
}
\value{
Updated Protein DataFrame with immunogen column removed
}
\description{
An existing immunogen is removed from a Protein DataFrame by calling `removeImmunogen()`.
}
\examples{
proteinDF <- getProteinFeatures("P55087")
proteinDF <- addImmunogen(proteinDF, start=10, end=30, name="A12")
proteinDF <- removeImmunogen(proteinDF, "A12")
}
