% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProtein.R
\name{plotProtein}
\alias{plotProtein}
\title{Plot protein features with immunogens highlighted}
\usage{
plotProtein(proteinDF)
}
\arguments{
\item{proteinDF}{Protein DataFrame created by call to getProteinFeatures()}
}
\value{
A ggplot object
}
\description{
A call to `plotProtein()` visualizes all relevant protein features within one figure along
the entire protein sequence. All immunogens associated with the protein are highlighted at their
position along the protein sequence by darkred boxes.
}
\examples{
proteinDF <- getProteinFeatures("P55087")
proteinDF <- addImmunogen(proteinDF, start=10, end=30, name="A12")
plotProtein(proteinDF)
}
