% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMotif.R
\name{calculateMotif}
\alias{calculateMotif}
\title{Motif Enumeration and Counting}
\usage{
calculateMotif(
  input.sequences,
  motif.lengths = 2:5,
  min.depth = 3,
  discontinuous = FALSE,
  discontinuous.symbol = ".",
  nthreads = 1
)
}
\arguments{
\item{input.sequences}{Character vector of sequences (amino acid or 
nucleotide)}

\item{motif.lengths}{Integer vector of motif sizes (>= 1). **Default:** `2:5`.}

\item{min.depth}{Minimum count a motif must reach to be retained in the 
output (`>= 1`). **Default:** `3`.}

\item{discontinuous}{Logical; include single-gap motifs as well? 
**Default:** `FALSE`.}

\item{discontinuous.symbol}{Single character representing the gap when
`discontinuous = TRUE`. **Default:** `"."`.}

\item{nthreads}{Integer number of OpenMP threads to use. `1` forces serial 
execution. **Default:** `1`.}
}
\value{
A `data.frame` with two columns:
\describe{
  \item{motif}{Motif string (contiguous or gapped).}
  \item{frequency}{Integer occurrence count across all sequences.}
}
}
\description{
Rapidly enumerates and quantifies **contiguous** (and, optionally, 
single-gap discontinuous) amino-acid motifs across a set of sequences.
}
\details{
For every input sequence the algorithm slides windows of length *k*
(`motif.lengths`) and increments a motif counter (`unordered_map`).
If `discontinuous = TRUE`, each window is additionally copied *k*
times, substituting one position at a time with `discontinuous.symbol`
(default `"."`), yielding gapped motif patterns such as `"C.S"`.
}
\examples{
seqs <- c("CASSLGQDTQYF", "CASSAGQDTQYF", "CASSLGEDTQYF")
calculateMotif(seqs, motif.lengths = 3, min.depth = 2)


}
