% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readImagefromTXT.R
\name{readImagefromTXT}
\alias{readImagefromTXT}
\title{Reads one or multiple .txt files into a CytoImageList object}
\usage{
readImagefromTXT(
  path,
  pattern = ".txt$",
  channel_pattern = "[A-Za-z]{1,2}[0-9]{2,3}Di",
  index_names = c("X", "Y"),
  BPPARAM = SerialParam()
)
}
\arguments{
\item{path}{Full path to where the individual .txt files are located. This is
usualy the path where the .mcd file is located.}

\item{pattern}{pattern to select which files should be read in (default
\code{".txt$"}).}

\item{channel_pattern}{regular expression to select the channel names from
the files.}

\item{index_names}{exact names of the columns storing the x and y coordinates 
of the image}

\item{BPPARAM}{parameters for parallelized reading in of images. 
This is only recommended for very large images.}
}
\value{
returns a \code{\linkS4class{CytoImageList}} object containing one
\code{\linkS4class{Image}} object per .txt file.
}
\description{
Reader function to generate \code{\linkS4class{Image}} objects
in form of a \code{\linkS4class{CytoImageList}} container from .txt files.
}
\section{Imaging mass cytometry .txt files}{

As part of the raw data folder, the Hyperion imaging system writes out
one .txt file per acquisition. These files store the ion counts per
pixel and channel. 

This function reads these .txt files into a single
\code{\linkS4class{CytoImageList}} object for downstream analysis. The
\code{pattern} argument allows selection of all .txt files or a specific
subset of files. The \code{\link[cytomapper]{channelNames}} of the
\code{CytoImageList} object are determined by the \code{channel_pattern}
argument.
}

\examples{
path <- system.file("extdata/mockData/raw", package = "imcRtools")

# Read in all images
x <- readImagefromTXT(path)
x

# Read in specific files
y <- readImagefromTXT(path, pattern = "ROI_002")
y

# Read in other channelNames
z <- readImagefromTXT(path, channel_pattern = "[A-Za-z]{2}[0-9]{3}")
z

}
\seealso{
\code{\linkS4class{CytoImageList}} for the container

\code{\link[BiocParallel]{MulticoreParam}} for parallelized processing

\code{\linkS4class{Image}} for the multi-channel image object

\code{vignette("cytomapper")} for visualization of multi-channel images
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
