% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ideal.R
\name{ideal}
\alias{ideal}
\title{ideal: Interactive Differential Expression Analysis}
\usage{
ideal(
  dds_obj = NULL,
  res_obj = NULL,
  annotation_obj = NULL,
  countmatrix = NULL,
  expdesign = NULL,
  gene_signatures = NULL
)
}
\arguments{
\item{dds_obj}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object. If not provided, then a
\code{countmatrix} and a \code{expdesign} need to be provided. If none of
the above is provided, it is possible to upload the data during the
execution of the Shiny App}

\item{res_obj}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object. If not provided, it can
be computed during the execution of the application}

\item{annotation_obj}{A \code{data.frame} object, with row.names as gene
identifiers (e.g. ENSEMBL ids) and a column, \code{gene_name}, containing
e.g. HGNC-based gene symbols. If not provided, it can be constructed during
the execution via the org.eg.XX.db packages - these need to be installed}

\item{countmatrix}{A count matrix, with genes as rows and samples as columns.
If not provided, it is possible to upload the data during the execution of
the Shiny App}

\item{expdesign}{A \code{data.frame} containing the info on the covariates
of each sample. If not provided, it is possible to upload the data during the
execution of the Shiny App}

\item{gene_signatures}{A list of vectors, one for each pathway/signature. This
is for example the output of the \code{\link[=read_gmt]{read_gmt()}} function. The provided
object can also be replaced during runtime in the dedicated upload widget.}
}
\value{
A Shiny App is launched for interactive data exploration and
differential expression analysis
}
\description{
ideal makes differential expression analysis interactive, easy and reproducible.
This function launches the main application included in the package.
}
\examples{
# with simulated data...
library("DESeq2")
dds <- DESeq2::makeExampleDESeqDataSet(n = 100, m = 8)
cm <- counts(dds)
cd <- colData(dds)

# with the well known airway package...
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
  colData = colData(airway),
  design = ~ cell + dex
)
\dontrun{

ideal()
ideal(dds)
ideal(dds_airway)

dds_airway <- DESeq2::DESeq(dds_airway)
res_airway <- DESeq2::results(dds_airway)
ideal(dds_airway, res_airway)
}

}
