% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotting_functions.R
\docType{methods}
\name{plotTSSprecision}
\alias{plotTSSprecision}
\alias{plotTSSprecision,GRanges,character-method}
\alias{plotTSSprecision,GRanges,CapSet-method}
\title{Compare the precision of TSS detection between multiple samples}
\usage{
plotTSSprecision(
  reference,
  detectedTSS,
  distanceCutoff = 500,
  outFile = NULL,
  ...
)

\S4method{plotTSSprecision}{GRanges,character}(
  reference,
  detectedTSS,
  distanceCutoff = 500,
  outFile = NULL,
  sampleNames
)

\S4method{plotTSSprecision}{GRanges,CapSet}(
  reference,
  detectedTSS,
  distanceCutoff = 500,
  outFile = NULL,
  ...
)
}
\arguments{
\item{reference}{Reference Transcrips/Genes as a \code{\link{GRanges}} object}

\item{detectedTSS}{Either a CapSet object with TSS information (after running \code{\link{detectTSS}})
or a character vector with paths to the BED files containing detcted TSSs}

\item{distanceCutoff}{integer. Maximum distance (in base pairs) from reference TSS to plot}

\item{outFile}{character. Output file name (filename extention would be used to determine type)
If outfile not specified, the plot would be returned on the screen}

\item{...}{Additional arguments}

\item{sampleNames}{character. Labels for input samples (in the same order as the input bed files)}
}
\value{
A ggplot object, or a file. Plot showing perent of TSS detected per sample with respect to
        their cumulative distance to TSS of the provided reference
}
\description{
Plot precision of TSS detection from multiple samples (bed files) with respect to
a given reference annotation.

Plot precision of TSS detection from multiple samples present within a
\code{\link{CapSet}} object, with respect to a given reference annotation.
}
\examples{

# load a txdb object
suppressMessages(library("TxDb.Dmelanogaster.UCSC.dm6.ensGene"))
library(GenomeInfoDb)  # for seqlevelsStyle()
seqlevelsStyle(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "ENSEMBL"
transcripts <- transcripts(TxDb.Dmelanogaster.UCSC.dm6.ensGene)

# Plotting the precision using a pre computed set of TSS (.bed files) :

tssfile <- system.file("extdata", "testTSS_merged.bed", package = "icetea")
plotTSSprecision(reference = transcripts, detectedTSS = tssfile,
                sampleNames = "testTSS", distanceCutoff = 500,
                outFile = "TSS_detection_precision.png")

## Plotting the precision using a CapSet object :

library("TxDb.Dmelanogaster.UCSC.dm6.ensGene")
library(GenomeInfoDb)  # for seqlevelsStyle()
seqlevelsStyle(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "ENSEMBL"
# only use chrX to make the analysis faster
seqlevels(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "X"
transcripts <- transcripts(TxDb.Dmelanogaster.UCSC.dm6.ensGene)

# load a previously saved CapSet object
cs <- exampleCSobject()
# plot
plotTSSprecision(reference = transcripts, detectedTSS = cs,
                  outFile = "TSS_detection_precision.png")

}
