% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerDEFields.R
\name{registerDEFields}
\alias{registerDEFields}
\alias{registerPValueFields}
\alias{registerAveAbFields}
\alias{registerLogFCFields}
\alias{registerPValuePatterns}
\alias{registerAveAbPatterns}
\alias{registerLogFCPatterns}
\alias{getPValueFields}
\alias{getAveAbFields}
\alias{getLogFCFields}
\alias{getPValuePatterns}
\alias{getAveAbPatterns}
\alias{getLogFCPatterns}
\title{Register DE-related fields}
\usage{
registerPValueFields(se, fields)

registerAveAbFields(se, fields)

registerLogFCFields(se, fields)

registerPValuePatterns(se, patterns)

registerAveAbPatterns(se, patterns)

registerLogFCPatterns(se, patterns)

getPValueFields(se)

getAveAbFields(se)

getLogFCFields(se)

getPValuePatterns(se, defaults = c("PValue", "p.value", "pval"))

getAveAbPatterns(se, defaults = c("AveExpr", "logCPM"))

getLogFCPatterns(se, defaults = c("logFC", "LogFC"))
}
\arguments{
\item{se}{A \linkS4class{SummarizedExperiment} to be visualized with various DE-related Panels.
This is expected to have a number of DE-related fields in its \code{\link{rowData}}.}

\item{fields}{A character vector containing the names of the relevant fields containing the DE statistics.
Alternatively \code{NULL} to remove any existing setting.}

\item{patterns}{A character vector containing partial names,
to match against the \code{colnames} of the \code{\link{rowData}} to identify relevant fields containing DE statistics.
Alternatively \code{NULL} to remove any existing setting.}

\item{defaults}{Character vector specifying the default patterns to provide when no patterns were registered in \code{se}.}
}
\value{
All \code{register} functions will return \code{se}, modified to contain the supplied \code{patterns} or \code{fields}.
These will be used as suggestions by DE-related Panels to identify the relevant fields.

All \code{get} functions will return a character vector containing the value set by the corresponding \code{register} function;
or \code{NULL}, if nothing was set.
}
\description{
Register the names of fields containing various DE statistics, to populate the user interface of DE-related \linkS4class{Panel}s.
}
\details{
DE-related Panels need to find relevant \code{\link{rowData}} fields containing p-values, log-fold changes, etc. to set appropriate defaults in the user interface.
These functions allow a user to tune the definition of what those Panels consider to be relevant,
which is occasionally necessary if the DE statistics are stored in a \code{\link{rowData}} field with an unusual column name.
The idea is to \code{register} the relevant fields in \code{se}, which can then be supplied to \code{\link{iSEE}} with the affected Panels - see Examples.

The registered \code{fields} should be the names of appropriate columns in \code{\link{rowData}} containing continuous variables.
Columns containing categorical or non-atomic variables will generally be ignored.
For each DE statistic, if any \code{fields} are registered in \code{se}, they will be used directly and \code{patterns} will be ignored.

The registered \code{patterns} are used for partial name matching to the names of appropriate columns of \code{\link{rowData}}.
All partial matching must be exact - regular expressions are not supported.
Matches can occur anywhere in the name.
For example, with \code{"PValue"}, columns with the names \code{"PValue.X"} and \code{"X.PValue"} will be considered acceptable matches.
If no \code{patterns} are supplied, the Panels will use the values in \code{defaults}.
}
\examples{
# Making up some results with unusual names.
se <- SummarizedExperiment(matrix(rnorm(10000), 1000, 10))
rownames(se) <- paste0("GENE_", seq_len(nrow(se)))
rowData(se)$pvalue <- runif(nrow(se))
rowData(se)$lfc <- rnorm(nrow(se))
rowData(se)$average <- rnorm(nrow(se))

se <- registerPValueFields(se, "pvalue")
getPValueFields(se)
se <- registerAveAbFields(se, "average")
getAveAbFields(se)
se <- registerLogFCFields(se, "lfc")
getLogFCFields(se)

if (interactive()) {
    iSEE(se, initial=list(MAPlot()))
}

}
\author{
Aaron Lun
}
