% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-RowGraphPlot.R
\docType{class}
\name{RowGraphPlot-class}
\alias{RowGraphPlot-class}
\alias{RowGraphPlot}
\title{Row graph plot}
\value{
The \code{RowGraphPlot(...)} constructor creates an instance of a
RowGraphPlot class, where any slot and its value can be passed to \code{...}
as a named argument.
}
\description{
Network organisation for the features of a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object. The igraph should be stored in the \code{metadata} slot by a name
containing \code{"graph"}. This panel uses
\code{\link[miaViz:plotColGraph]{plotRowGraph}}
to generate the plot.
}
\section{Slot overview}{


This class inherits all slots from its parent class \linkS4class{GraphPlot}.
}

\examples{
library(mia)
library(miaViz)
data("GlobalPatterns", library = "mia")
data("row_graph", library = "miaViz")

tse <- GlobalPatterns
tse <- agglomerateByRank(tse,
                         rank = "Genus",
                         na.rm = TRUE)
                         
metadata(tse)$graph <- row_graph

# Store panel into object
panel <- RowGraphPlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\seealso{
\linkS4class{GraphPlot}
\linkS4class{ColumnGraphPlot}
}
\author{
Giulio Benedetti
}
