% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-SummarizedExperiment.R
\name{contrastResultsNames}
\alias{contrastResultsNames}
\alias{contrastResults}
\title{Extract contrast results embedded in a SummarizedExperiment object}
\usage{
contrastResultsNames(object)

contrastResults(object, name)
}
\arguments{
\item{object}{A \linkS4class{SummarizedExperiment} object.}

\item{name}{(Optional) Name of a single contrast result name to extract.
Use \code{contrastResultsNames(object)} to list available names.}
}
\value{
For \code{contrastResultsNames}: the names of embedded contrast results available.

For \code{contrastResults}: a \code{DataFrame} of differential expression statistics.

If \code{name} is missing, \code{contrastResults} returns a nested \code{\linkS4class{DataFrame}} in which each column contains the results of a single contrast.
If \code{name} is given, \code{contrastResults} returns a \code{\linkS4class{DataFrame}} that contains the results of a single contrast.
}
\description{
\code{contrastResults} returns either all contrasts results stored in \code{object} or a single contrast result by name.

\code{contrastResultsNames} returns the names of contrast results embedded in \code{object}.
}
\examples{
library("iSEEde")
library("airway")
library("DESeq2")
library("iSEE")

##
# Example data ----
##

data("airway")
airway$dex <- relevel(airway$dex, "untrt")

dds <- DESeqDataSet(airway, ~ 0 + dex + cell)

dds <- DESeq(dds)
res_deseq2 <- results(dds, contrast = list("dextrt", "dexuntrt"))
airway <- embedContrastResults(res_deseq2, airway, name = "dex: trt vs untrt")

##
# List result names ---
##

contrastResultsNames(airway)

##
# Extract results ---
##

contrastResults(airway)
contrastResults(airway, "dex: trt vs untrt")
}
