% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_select.R
\name{.processMultiSelections}
\alias{.processMultiSelections}
\title{Process multiple selections}
\usage{
.processMultiSelections(x, all_memory, all_contents, envir)
}
\arguments{
\item{x}{An instance of a \linkS4class{Panel} class.}

\item{all_memory}{A named list of \linkS4class{Panel} instances containing parameters for the current app state.}

\item{all_contents}{A named list of arbitrary contents with one entry per panel.}

\item{envir}{The evaluation environment.
This is assumed to already contain \code{se}, the \linkS4class{SummarizedExperiment} object for the current dataset.}
}
\value{
\code{envir} is populated with one, none or both of \code{col_selected} and/or \code{row_selected},
depending on whether \code{x} is receiving a multiple selection on the rows and/or columns.
The return value is the  character vector of commands required to construct those variables.
}
\description{
Generate and execute commands to process multiple selections,
creating variables in the evaluation environment with the identity of the selected rows or columns.
}
\details{
This function is primarily intended for use by developers of new panels.
It should be called inside \code{\link{.generateOutput}} to easily process row/column multiple selections.
Developers can check whether \code{row_selected} or \code{col_selected} exists in \code{envir}
to determine whether any row or column selection was performed (and adjust the behavior of \code{.generateOutput} accordingly).
}
\seealso{
\code{\link{.generateOutput}} and its related generic \code{\link{.renderOutput}}, where this function should generally be used.
}
\author{
Aaron Lun
}
