% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observers_modal.R
\name{.createCustomDimnamesModalObservers}
\alias{.createCustomDimnamesModalObservers}
\title{Create observers for a modal for custom dimnames}
\usage{
.createCustomDimnamesModalObservers(
  plot_name,
  slot_name,
  button_name,
  se,
  input,
  session,
  pObjects,
  rObjects,
  source_type
)
}
\arguments{
\item{plot_name}{String containing the name of the current panel.}

\item{slot_name}{String specifying the slot of containing the names of the custom features.
This will be modified by user interactions with the modal.}

\item{button_name}{String containing the name of the button in the panel UI that launches the modal.}

\item{se}{A \linkS4class{SummarizedExperiment} object after running \code{\link{.cacheCommonInfo}}.}

\item{input}{The Shiny input object from the server function.}

\item{session}{The Shiny session object from the server function.}

\item{pObjects}{An environment containing global parameters generated in the \code{\link{iSEE}} app.}

\item{rObjects}{A reactive list of values generated in the \code{\link{iSEE}} app.}

\item{source_type}{String specifying the type of the panel that is source of the selection, either \code{"row"} or \code{"column"}.}
}
\value{
Observers are set up to launch the modal and monitor its UI elements.
A \code{NULL} is invisibly returned.
}
\description{
Create observers to launch a modal where users can input a list of custom row or column names.
These observers register input changes in the app's memory and request an update to the affected panel.
}
\details{
This should be called in \code{\link{.createObservers}} for the target panel.
It assumes that a button element with the suffix \code{button_name} is available in the UI (i.e., the full name is created by concatenated \code{plot_name} with \code{button_name}).

The modal UI provides options to sort the dimnames, validate them, clear the current text and import a selection from a specified row transmitter.
These are all transient until \dQuote{Apply} is clicked, at which point the app's memory is modified and an update is requested.

The custom names are stored in the \code{slot_name} as a single string with names separated by newlines.
Hashes are treated as comments and any content after a hash is ignored when interpreting the names.
Any leading and trailing whitespace is also ignored during interpretation.
}
\author{
Kevin Rue-Albrecht
}
