% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iGC.R
\docType{package}
\name{iGC}
\alias{iGC}
\alias{iGC-package}
\title{iGC: an integrated analysis package of gene expression and copy number
alteration}
\description{
The iGC package is used to identify CNA-driven differentially expressed
genes. The iGC package provides four categories of important functions:
`create_sample_desc`, `create_gene_ex`, `create_gene_cna` and
`find_cna_drive_gene`.
}
\section{create_sample_desc}{
 The create_sample_desc function is provided for
  creating a sample description table containing all required inputs.
}

\section{create_gene_exp function}{
 The create_gene_exp function is used to
  rearrange the input gene expression files into a gene expression list of
  entire samples.
}

\section{create_gene_cna function}{
 The create_gene_cna function maps CNA data
  to human genes and then defines the mapped human genes as CN gain or loss
  based on the CN threshold, whose default values are set as 2.5 for gain and
  1.5 for loss. These mapped genes will be assigned values in +1, -1 or 0,
  where +1 stands for CNA-gain, -1 stands for CNA-loss and 0 stands for
  neutral.
}

\section{find_cna_driven_gene function}{
 The find_cna_driven_gene function
  identifies CNA-driven differentially expressed genes. The input mapped
  genes remain for further analyses if its ratio of the number of CN changed
  samples, CNA-gain (G) or CNA-loss (L), to the number of total samples is
  larger than a given threshold. Here the default setting is that only genes
  showing CNAs in at least 20% of the samples will be analyzed further. Then,
  statistical tests, T-test and Wilcoxon rank sum test, are performed in the
  GE level by classifying the samples as G and L plus Nertral (N) groups or L
  and G plus N groups, depending on the CN of the interested gene increases
  or decreases.
}

