% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COBRAPerformance.R
\name{update_cobraperformance}
\alias{update_cobraperformance}
\title{Update \code{COBRAPerformance} or \code{COBRAPlot} object to the current
version of the class format}
\usage{
update_cobraperformance(object, quiet = FALSE)
}
\arguments{
\item{object}{A \code{COBRAPerformance} or \code{COBRAPlot} object}

\item{quiet}{Set to TRUE to disable messages listing the modifications that
are applied to the object}
}
\value{
An updated \code{COBRAPerformance} or \code{COBRAPlot} object
}
\description{
Update a \code{COBRAPerformance} or \code{COBRAPlot} object generated by a
previous version of the package to the latest version.
}
\examples{
cobradata <- cobradata_example_sval

cobraperf <- calculate_performance(cobradata, 
                                   binary_truth = "status", 
                                   aspects = "fpr")
cobraperf <- update_cobraperformance(cobraperf)
}
\author{
Charlotte Soneson
}
