% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{tpr}
\alias{tpr}
\alias{tpr<-}
\alias{tpr,COBRAPerformance-method}
\alias{tpr<-,COBRAPerformance,data.frame-method}
\alias{tpr,COBRAPlot-method}
\alias{tpr<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{tpr} slot}
\usage{
tpr(x, ...)

tpr(x, ...) <- value

\S4method{tpr}{COBRAPerformance}(x)

\S4method{tpr}{COBRAPerformance,data.frame}(x) <- value

\S4method{tpr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information about the observed TPR for each
method and each stratification level, at various adjusted p-value
thresholds.}
}
\value{
The accessor function returns a data frame giving information about
  the observed TPR for each method and each stratification level, at various
  adjusted p-value thresholds.
}
\description{
Accessor and replacement functions for the \code{tpr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "tpr")
head(tpr(cobraperf))
}
\author{
Charlotte Soneson
}
