% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_emap.R
\name{hyp_emap}
\alias{hyp_emap}
\title{Visualize hyp/multihyp objects as an enrichment map}
\usage{
hyp_emap(
  hyp_obj,
  similarity_metric = c("jaccard_similarity", "overlap_similarity"),
  similarity_cutoff = 0.2,
  pval = 1,
  fdr = 1,
  val = c("fdr", "pval"),
  top = NULL,
  title = ""
)
}
\arguments{
\item{hyp_obj}{A hyp or multihyp object}

\item{similarity_metric}{Metric to calculate geneset similarity}

\item{similarity_cutoff}{Geneset similarity cutoff}

\item{pval}{Filter results to be less than pval cutoff}

\item{fdr}{Filter results to be less than fdr cutoff}

\item{val}{Choose significance value shown above nodes e.g. c("fdr", "pval")}

\item{top}{Limit number of pathways shown}

\item{title}{Plot title}
}
\value{
A visNetwork object
}
\description{
Visualize hyp/multihyp objects as an enrichment map
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG_LEGACY")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

hyp_emap(hyp_obj, top=30, val="fdr")

}
