% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_heatmap.R
\name{draw_heatmap}
\alias{draw_heatmap}
\title{Heatmap for Gene Expression Counts}
\usage{
draw_heatmap(
  object,
  assay_name,
  color_extremes = c(0.01, 0.99),
  col_data_annotation = NULL,
  ...
)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{assay_name}{(\code{string})\cr selects assay from input.}

\item{color_extremes}{(\code{numeric})\cr min and max percentiles to inform the color scheme
of the heatmap as blue and red respectively.}

\item{col_data_annotation}{(\code{character} or \code{NULL})\cr optional grouping variable(s), taken
from input sample variables.}

\item{...}{additional arguments to pass to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}
}
\value{
The \code{ComplexHeatmap::Heatmap} heatmap
}
\description{
This produces a heatmap of the chosen assay and groups by various sample variables.
}
\examples{
result <- hermes_data \%>\%
  normalize(methods = "voom") \%>\%
  add_quality_flags() \%>\%
  filter(what = "genes")

draw_heatmap(
  object = result[1:10, ],
  assay_name = "counts",
  col_data_annotation = "COUNTRY"
)

draw_heatmap(
  object = result[1:10, ],
  assay_name = "counts",
  color_extremes = c(0.001, 0.999),
  col_data_annotation = "AGEGRP"
)
}
