% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_boxplot.R
\name{draw_boxplot}
\alias{draw_boxplot}
\alias{h_draw_boxplot_df}
\title{Boxplot for Gene Expression Values}
\usage{
draw_boxplot(
  object,
  assay_name,
  genes,
  x_var = NULL,
  color_var = NULL,
  facet_var = NULL,
  violin = FALSE,
  jitter = FALSE
)

h_draw_boxplot_df(object, assay_name, genes, x_var, color_var, facet_var)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{assay_name}{(\code{string})\cr selects assay from input for the y-axis.}

\item{genes}{(\code{GeneSpec})\cr for which genes or which gene signature to produce boxplots.}

\item{x_var}{(\code{string} or \code{NULL})\cr optional stratifying variable for the x-axis,
taken from input sample variables.}

\item{color_var}{(\code{string} or \code{NULL})\cr optional color variable, taken from
input sample variables.}

\item{facet_var}{(\code{string} or \code{NULL})\cr optional faceting variable, taken
from input sample variables.}

\item{violin}{(\code{flag})\cr whether to draw a violin plot instead of a boxplot.}

\item{jitter}{(\code{flag})\cr whether to add jittered original data points.}
}
\value{
The \code{ggplot} boxplot.
}
\description{
This produces boxplots of the gene expression values of a single gene, multiple genes or
a gene signature.
}
\section{Functions}{
\itemize{
\item \code{h_draw_boxplot_df()}: Helper function to prepare the data frame required
for plotting.

}}
\examples{
object <- hermes_data
draw_boxplot(
  object,
  assay_name = "counts",
  genes = gene_spec(c(A = genes(object)[1])),
  violin = TRUE
)

object2 <- object \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize()
draw_boxplot(
  object2,
  assay_name = "tpm",
  x_var = "SEX",
  genes = gene_spec(setNames(genes(object2)[1:10], 1:10), fun = colMeans),
  facet_var = "RACE",
  color_var = "AGE18",
  jitter = TRUE
)

draw_boxplot(
  object,
  assay_name = "counts",
  x_var = "SEX",
  genes = gene_spec(genes(object)[1:3]),
  jitter = TRUE,
  facet_var = "AGE18"
)

draw_boxplot(
  object,
  assay_name = "counts",
  genes = gene_spec(c(A = "GeneID:11185", B = "GeneID:10677")),
  violin = TRUE
)
}
