% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{processHDE}
\alias{processHDE}
\title{Function to curate and HDExaminer file so that in contains all the information
in a sensible format. This object can then be straightforwardly passed to
a object of class \code{QFeatures}}
\usage{
processHDE(HDExaminerFile, proteinStates = NULL)
}
\arguments{
\item{HDExaminerFile}{an object of class data.frame containing an HDExaminer
data}

\item{proteinStates}{a character vector indicating the protein states}
}
\value{
A wide format data frame with HDExaminer data
}
\description{
Function to curate and HDExaminer file so that in contains all the information
in a sensible format. This object can then be straightforwardly passed to
a object of class \code{QFeatures}
}
\examples{
sample_data <- data.frame(read.csv(system.file("extdata", "ELN55049_AllResultsTables_Uncurated.csv", package = "hdxmsqc", mustWork = TRUE), nrows = 10))

processHDE(sample_data) 

}
\author{
Oliver Crook
}
