% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{plotMonotoneStat}
\alias{plotMonotoneStat}
\title{Monotonicity based outlier detection, plot.}
\usage{
plotMonotoneStat(object, experiment = NULL, timepoints = NULL)
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{experiment}{A character vector indicating the experimental conditions}

\item{timepoints}{A numeric vector indicating the experimental timepoints}
}
\description{
Monotonicity based outlier detection, plot.
}
\examples{
library("RColorBrewer")
data("BRD4df_full")
experiment <- c("wt", "iBET")
timepoints <- rep(c(0, 15, 60, 600, 3600, 14000), each = 3)
monoStat <- computeMonotoneStats(object = BRD4df_full,
experiment = experiment, 
timepoints = timepoints)
}
\author{
Oliver Crook
}
