\name{tallyBAM}
\alias{tallyBAM}

\title{tallyBAM}
\description{
Function for creating tallies from bam files.
}
\usage{
tallyBAM(file, chr, start, stop, q=25, ncycles = 0, max.depth=1000000, verbose=FALSE, reference = NULL)
}
\arguments{
  \item{file}{ filename of the BAM file that should be tallies}
  \item{chr}{Chromosome in which to tally}
  \item{start}{ First position of the tally }
  \item{stop}{ Last position of the tally }
  \item{q}{quality cut-off for considering a base call}
  \item{ncycles}{number of sequencing cycles form the front and back of the read that should be considered unreliable}
  \item{max.depth}{only tally a position if there are less than this many reads overlapping it - can prevent long runtimes in unreliable regions}
  \item{verbose}{should additional information be printed}
  \item{reference}{\code{DNAString} object holding the reference sequence of the region being tallies, if this is \code{NULL} (the default) the raw tally is returned, otherwise \code{\link{prepareForHDF5}} is called with the raw tally and the reference and the prepared tally is returned instead}
}
\details{
  This function tallies nucleotides and deletion counts in the specified region of a given BAM file. The results can be processed with the \code{\link{prepareForHDF5}} function.
  
  This function was adapted from the \code{\link[deepSNV]{bam2R}} function provided by the \code{deepSNV} package.
  }
\value{
  An array object with dimensions \code{[stop - start + 1, 18, 2]} which represent positions times nucleotides (4 bases + deletions + insertions times three for early, middle and late sequencing cycles) times strands.
  }
\author{
Paul Pyl
}

\examples{
library(h5vc)
files <- c("NRAS.AML.bam","NRAS.Control.bam")
bamFiles <- file.path( system.file("extdata", package = "h5vcData"), files)
chrom = "1"
startpos <- 115247090
endpos <- 115259515
theData <- lapply( bamFiles, function(bamf){
  tallyBAM( file = bamf, chr = chrom, start = startpos, stop = endpos, ncycles = 10 )
})
str(theData)
print(theData[[1]][,,,9491]) #position 9491 of the pileup
}