\name{Coverage}
\alias{binnedCoverage}
\title{Coverage analysis}
\description{
Functions to do analyses based on coverage
}
\usage{
binnedCoverage( data, sampledata, gccount = FALSE )
}

\arguments{
\item{data}{A \code{list} with element \code{Coverage} (a 3d \code{integer} array of size [1:2, 1:k, 1:n])}
\item{sampledata}{A \code{data.frame} with \code{k} rows (one for each
  sample) and columns \code{Type}, \code{Column} and (\code{SampleGroup}
  or \code{Patient}). The tally file should contain this information as
  a group attribute, see \code{getSampleData} for an example.}
  \item{gccount}{Boolean flag to specify whether the gc count of the bin should be reported as well, \code{Reference} must be a slot in the \code{data} object}
}
\details{
  Explanations:

  This computes the per sample coverage in a given bin (determined by
  the width of \code{data}).
  This feature is not implemented yet!
}
\value{
  Returns a \code{data.frame} with columns containing the coverage with
  the current bin for all samples provided in \code{sampledata}.
  The binsize is determined by the \code{blocksize} argument given to
  \code{h5dapply} when this function is run directly on a tally file.
}
\author{
Paul Pyl
}

\examples{
  # loading library and example data
  library(h5vc)
  tallyFile <- system.file( "extdata", "example.tally.hfs5", package = "h5vcData" )
  sampleData <- getSampleData( tallyFile, "/ExampleStudy/22" )
  data <- h5dapply( # extractting coverage binned at 1000 bases
    filename = tallyFile,
    group = "/ExampleStudy/22",
    blocksize = 1000,
    FUN = binnedCoverage,
    sampledata = sampleData,
    gccount = TRUE,
    names = c( "Coverages", "Reference" ),
    range = c(38900000,39000000)
  )
  data <- do.call(rbind, data)
  rownames(data) <- NULL
  head(data)
}