getChromSize <- function( tallyFile, group, dataset = "Reference", posDim = 1 ){
  .getDimensions( tallyFile, group, dataset )[posDim]
}

.getDimensions <- function( tallyFile, group, dataset ){
  f <- H5Fopen(tallyFile, flags = "H5F_ACC_RDONLY")
  g <- H5Gopen(f, group)
  d <- H5Dopen(g, dataset)
  s <- H5Dget_space(d)
  ret <- H5Sget_simple_extent_dims(s)$size
  H5Sclose(s)
  H5Dclose(d)
  H5Gclose(g)
  H5Fclose(f)
  return(ret)
}