% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.graper.R
\name{coef.graper}
\alias{coef.graper}
\title{Get estimated coefficients from a graper object}
\usage{
\method{coef}{graper}(object, include_intercept = TRUE, ...)
}
\arguments{
\item{object}{fitted graper model as obtained from  \code{\link{graper}}}

\item{include_intercept}{whether to include the estimated
intercept value in the output}

\item{...}{other arguments}
}
\value{
1-Column matrix of estimated coefficients.
}
\description{
Function to obtain estimated coefficients
from a fitted graper model.
}
\examples{
# create data
dat <- makeExampleData()
# fit the graper model to the data
fit <- graper(dat$X, dat$y, dat$annot)
# extract the model coefficients
coef(fit)
}
