% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.permu}
\alias{intern.permu}
\title{Internal function}
\usage{
intern.permu(n, it, group, kind)
}
\arguments{
\item{n}{Number of samples.}

\item{it}{Number of repetitions.}

\item{group}{Either \code{NULL} or a factor
of length \code{n}.}

\item{kind}{computation \strong{:}
number between 0 and 1}
}
\value{
The function returns a matrix.
}
\description{
The number of permutations of \code{n} elements is \code{n!}.
This function randomly rearranges the elements \code{it} times,
and then deletes all duplicates.
Thus it finds always less than \code{it} and \code{n!} permutations.
If a confounding variable is provided,
the function uses stratified permutation.
This function is called by the functions \code{\link{omnibus}}
and \code{\link{proprius}}.
}
\examples{
group <- as.factor(c('A','A','B','B','B'))
set.seed(1)
intern.permu(n=5,it=1000,group=group,kind=1)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions
are \code{\link{cursus}}, \code{\link{omnibus}},
and \code{\link{proprius}}.
}
\keyword{internal}
