% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_options.R
\name{.calcPenalty}
\alias{.calcPenalty}
\title{Calculate penalty based on data}
\usage{
.calcPenalty(xdata, penaltyType, options = networkOptions())
}
\arguments{
\item{xdata}{input data}

\item{penaltyType}{which method to use}

\item{options}{options to be used}
}
\value{
vector with penalty weights
}
\description{
Internal method to calculate the network using data-dependant methods
}
\examples{
xdata <- matrix(rnorm(1000), ncol = 200)
glmSparseNet:::.calcPenalty(xdata, "none")
glmSparseNet:::.calcPenalty(
    xdata, "correlation",
    networkOptions(cutoff = .6)
)
glmSparseNet:::.calcPenalty(xdata, "correlation")
glmSparseNet:::.calcPenalty(
    xdata, "covariance",
    networkOptions(cutoff = .6)
)
glmSparseNet:::.calcPenalty(xdata, "covariance")
}
