% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-dim-utilities.R
\name{sc_dim_geom_feature}
\alias{sc_dim_geom_feature}
\title{sc_dim_geom_feature}
\usage{
sc_dim_geom_feature(
  object,
  features,
  dims = c(1, 2),
  ncol = 3,
  ...,
  .fun = function(.data) dplyr::filter(.data, .data$value > 0)
)
}
\arguments{
\item{object}{Seurat or SingleCellExperiment object}

\item{features}{selected features (i.e., genes)}

\item{dims}{selected dimensions (must be a two-length vector) that are used
in visualization}

\item{ncol}{number of facet columns if 'length(features) > 1'}

\item{...}{additional parameters pass to 'scattermore::geom_scattermore()'}

\item{.fun}{user defined function that will be applied to selected features
(default is to filter out genes with no expression values)}
}
\value{
layer of points for selected features
}
\description{
sc_dim_geom_feature
}
\examples{
library(scuttle)
library(scater)
library(scran)
library(ggplot2)
sce <- mockSCE()
sce <- logNormCounts(sce)
clusters <- clusterCells(sce, assay.type = 'logcounts')
colLabels(sce) <- clusters
sce <- runUMAP(sce, assay.type = 'logcounts')
p1 <- sc_dim(sce, reduction = 'UMAP')
set.seed(123)
genes <- rownames(sce) |> sample(6)
f1 <- p1 + 
      sc_dim_geom_feature(
        object = sce, 
        features = genes
      )
}
\seealso{
\code{\link[=sc_feature]{sc_feature()}}
}
