% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_functions.R
\name{highlight_set_nodes}
\alias{highlight_set_nodes}
\title{highlight_set_nodes}
\usage{
highlight_set_nodes(
  set,
  how = "all",
  name = "name",
  sep = " ",
  no_sep = FALSE,
  remove_dot = TRUE
)
}
\arguments{
\item{set}{set of identifiers}

\item{how}{if `all`, if node contains multiple
IDs separated by `sep`, highlight if all the IDs
are in query. if `any`, highlight if one of the IDs
is in query.}

\item{name}{which column to search for}

\item{sep}{separater for node names}

\item{no_sep}{not separate node name}

\item{remove_dot}{remove "..." after graphics name column}
}
\value{
boolean vector
}
\description{
identify if nodes are involved in specific queriy.
if multiple IDs are listed after separation by `sep`,
only return TRUE if all the IDs are in the query.
}
\examples{
graph <- create_test_pathway()
## Highlight set of nodes by specifying ID
graph <- graph |> mutate(hl=highlight_set_nodes(c("hsa:51428")))

## node column can be specified by `name` argument
graph <- graph |> 
    mutate(hl=highlight_set_nodes(c("DDX41"), name="graphics_name"))
}
