% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_functions.R
\name{highlight_entities}
\alias{highlight_entities}
\title{highlight_entities}
\usage{
highlight_entities(
  pathway,
  set,
  how = "any",
  num_combine = mean,
  name = "graphics_name",
  sep = ", ",
  no_sep = FALSE,
  show_type = "gene",
  fill_color = "tomato",
  remove_dot = TRUE,
  legend_name = NULL,
  use_cache = FALSE,
  return_graph = FALSE,
  directory = NULL
)
}
\arguments{
\item{pathway}{pathway ID to be passed to `pathway()`}

\item{set}{vector of identifiers, or named vector of numeric values}

\item{how}{if `all`, if node contains multiple
IDs separated by `sep`, highlight if all the IDs
are in query. if `any`, highlight if one of the IDs
is in query.}

\item{num_combine}{combining function if multiple hits are obtained per node}

\item{name}{which column to search for}

\item{sep}{separater for node names}

\item{no_sep}{not separate node name}

\item{show_type}{entitie type, default to 'gene'}

\item{fill_color}{highlight color, default to 'tomato'}

\item{remove_dot}{remove the "..." in the graphics name column}

\item{legend_name}{legend name, NULL to suppress}

\item{use_cache}{use cache or not}

\item{return_graph}{return tbl_graph instead of plot}

\item{directory}{directroy with XML files. ignore caching when specified.}
}
\value{
overlaid map
}
\description{
highlight the entities in the pathway,
overlay raw map and return the results.
Note that highlighted nodes are considered to be rectangular,
so it is not compatible with the type like `compound`.
}
\examples{
highlight_entities("hsa04110", c("CDKN2A"), legend_name="interesting")
}
