% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.cytoframe}
\alias{fortify.cytoframe}
\alias{fortify.flowFrame}
\alias{fortify.flowSet}
\alias{fortify}
\alias{fortify.cytoset}
\alias{fortify.ncdfFlowList}
\alias{fortify.GatingSetList}
\alias{fortify.GatingSet}
\title{Convert a flowFrame/flowSet/GatingSet to a ggplot-compatible data.table}
\usage{
\method{fortify}{cytoframe}(model, ...)

\method{fortify}{flowFrame}(model, data, ...)

\method{fortify}{flowSet}(model, data, ...)

\method{fortify}{cytoset}(model, ...)

\method{fortify}{ncdfFlowList}(model, ...)

\method{fortify}{GatingSetList}(model, ...)

\method{fortify}{GatingSet}(model, ...)
}
\arguments{
\item{model}{flowFrame, flowSet or GatingSet}

\item{...}{not used.}

\item{data}{not used.}
}
\value{
data.table

data.table

data.table
}
\description{
It extracts events matrices and appends the pData to it so that ggplot can use the pData for facetting.
}
\examples{
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))

attr(gs, "subset") <- "CD4" #must attach subset information to GatingSet object before foritfying it
fortify(gs)

fs <- gs_pop_get_data(gs, "CD8")
fortify(fs)#fs is a flowSet/ncdfFlowSet

fr <- fs[[1]]
fortify(fr)#fr is a flowFrame
}
