% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignCoor.R
\name{alignCoor}
\alias{alignCoor}
\title{Aligns two sets of genomic with x,y,z}
\usage{
alignCoor(query, subject)
}
\arguments{
\item{query, subject}{GRanges objects to alignment.}
}
\value{
A GRanges object of \code{query} aligned  to \code{subject}.
}
\description{
Aligns two sets of points via rotations and translations by Kabsch Algorithm.
}
\examples{
x <- readRDS(system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds",
  package = "geomeTriD"
))
res <- alignCoor(x, x)
A <- view3dStructure(x, k = 3, renderer = "none")
B <- view3dStructure(res, k = 3, renderer = "none")
B <- lapply(B, function(.ele) {
  .ele$side <- "right"
  .ele
})
threeJsViewer(c(A, B))
}
