% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakLengthBoxplot.r
\name{peakLengthBoxplot}
\alias{peakLengthBoxplot}
\title{Produces box-and-whisker plot of peak lengths within any genomic interval.}
\usage{
peakLengthBoxplot(organism, start, end)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}
}
\value{
Creates boxplots showing how lengths of peaks are distributed within any given genomic interval.  Also, creates character vector composed of individual peak lengths.
}
\description{
Makes boxplots of peak lengths to show how lengths of individual peaks are distributed within any genomic interval (e.g., 0-500 bp upstream of nearest gene for all genes throughout the genome).
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
peaksInput(allpeaks)
peakLengthBoxplot(rat, 0, 500)


}
