% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getSds}
\alias{getSds}
\alias{getSds,ClassifierParameters-method}
\title{Obtain classifiers' reference standard deviations.}
\usage{
getSds(object)

\S4method{getSds}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
Returns a numeric vector of probe set standard deviations 
as observed in the reference data
}
\description{
\code{getSds} returns the reference standard deviations
 encoded in the classifier.
}
\examples{
aClassifier <- getClassifier("EMC92")
getSds(aClassifier)
}
\seealso{
showClassifierList getClassifier runClassifier

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
