% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatom-package.R
\docType{package}
\name{gatom}
\alias{gatom}
\title{gatom: a package for finding an active metabolic module in atom transition network}
\description{
This package implements a metabolic network analysis pipeline to
identify an active metabolic module based on high throughput data.
The pipeline takes as input transcriptional and/or metabolic data
and finds a metabolic subnetwork (module) most regulated between the two
conditions of interest. The package further provides functions for module
post-processing, annotation and visualization.
}
\section{Functions}{


Data preprocessing:
\code{\link{prepareDE}}, \code{\link{getMetDEMeta}}, \code{\link{getGeneDEMeta}}

Graph creation:
\code{\link{makeMetabolicGraph}}

Graph scoring:
\code{\link{scoreGraph}}

Module postprocessing:
\code{\link{collapseAtomsIntoMetabolites}}, \code{\link{connectAtomsInsideMetabolite}},
\code{\link{addHighlyExpressedEdges}}, \code{\link{abbreviateLabels}}

Plotting module:
\code{\link{createShinyCyJSWidget}}

Exporting module:
\code{\link{saveModuleToHtml}}, \code{\link{saveModuleToDot}},
\code{\link{saveModuleToPdf}}, \code{\link{saveModuleToXgmml}}

For detailed pipeline analysis, see gatom vignette:
 \code{vignette("gatom-tutorial", package = "gatom")}
}

\section{Example Data}{

Example data provided by gatom consists of:
metabolite differential abundance data (\code{\link{met.de.rawEx}}),
gene differential expression data (\code{\link{gene.de.rawEx}}),
KEGG-based network object (\code{\link{networkEx}}),
KEGG-based metabolite database object (\code{\link{met.kegg.dbEx}}),
Example organism annotation object (\code{\link{org.Mm.eg.gatom.annoEx}}),
metabolic graph with atom topology (\code{\link{gEx}}),
scored metabolic graph with atom topology (\code{\link{gsEx}}),
and metabolic module (\code{\link{mEx}}).
}

