% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{logisticFit}
\alias{logisticFit}
\title{Logistic fit}
\usage{
logisticFit(
  concs,
  norm_values,
  std_norm_values = NA,
  x_0 = 1,
  priors = NULL,
  lower = NULL,
  range_conc = c(0.005, 5),
  force_fit = FALSE,
  pcutoff = 0.05,
  cap = 0.1,
  n_point_cutoff = 4,
  capping_fold = 5
)
}
\arguments{
\item{concs}{concentrations that have not been transformed into log space.}

\item{norm_values}{normalized response values (Untreated = 1).}

\item{std_norm_values}{std of values.}

\item{x_0}{upper limit.
Defaults to \code{1}. For co-treatments, this value should be set to \code{NA}.}

\item{priors}{numeric vector containing starting values for all.
mean parameters in the model. Overrules any self starter function.}

\item{lower}{numeric vector of lower limits for all parameters in a 4-param model.}

\item{range_conc}{range of concentration for calculating AOC_range.}

\item{force_fit}{boolean indicating whether or not to force a parameter-based fit.}

\item{pcutoff}{numeric of pvalue significance threshold above or equal to which to use a constant fit.}

\item{cap}{numeric value capping \code{norm_values} to stay below (\code{x_0} + cap).}

\item{n_point_cutoff}{integer indicating number of unique concentrations required to fit curve.}

\item{capping_fold}{Integer value of the fold number to use for capping IC50/GR50. Default is \code{5}.}
}
\value{
data.table with metrics and fit parameters.
}
\description{
Fit a logistic curve to drug response data.
}
\details{
Implementation of the genedata approach for curve fit:
https://screener.genedata.com/documentation/display/DOC21/Business-Rules-for-Dose-Response-Curve-Fitting,-Model-Selection,-and-Fit-Validity.html #nolint

The output parameter names correspond to the following definitions:
\describe{
\item{x_mean}{The mean of a given dose-response metric}
\item{x_AOC_range}{The range of the area over the curve}
\item{x_AOC}{The area over the GR curve or, respectively, under the relative
cell count curve, averaged over the range of concentration values}
\item{xc50}{The concentration at which the effect reaches a value of 0.5 based
on interpolation of the fitted curve}
\item{x_max}{The maximum effect of the drug}
\item{ec50}{The drug concentration at half-maximal effect}
\item{x_inf}{The asymptotic value of the sigmoidal fit to the dose-response
data as concentration goes to infinity}
\item{x_0}{The asymptotic metric value corresponding to a concentration of 0
for the primary drug}
\item{h}{The hill coefficient of the fitted curve, which reflects how steep
the dose-response curve is}
\item{r2}{The goodness of the fit}
\item{x_sd_avg}{The standard deviation of GR/IC}
\item{fit_type}{This will be given by one of the following:
\itemize{
\item{"DRC4pHillFitModel"} Successfully fit with a 4-parameter model
\item{"DRC3pHillFitModelFixS0"} Successfully fit with a 3-parameter model
\item{"DRCConstantFitResult"} Successfully fit with a constant fit
\item{"DRCTooFewPointsToFit"} Not enough points to run a fit
\item{"DRCInvalidFitResult"} Fit was attempted but failed
}
}
\item{maxlog10Concentration}{The highest log10 concentration}
\item{N_conc}{Number of unique concentrations}
}
}
\examples{
logisticFit(
c(0.001, 0.00316227766016838, 0.01, 0.0316227766016838),
c(0.9999964000144, 0.999964001439942, 0.999640143942423, 0.996414342629482),
rep(0.1, 4),
priors = c(2, 0.4, 1, 0.00658113883008419)
)

}
\keyword{fit_curves}
