% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_convert.R
\name{convert_colData_to_json}
\alias{convert_colData_to_json}
\title{Convert colData to JSON}
\usage{
convert_colData_to_json(
  cdata,
  identifiers,
  req_cols = c("cellline", "cellline_name", "cellline_tissue", "cellline_ref_div_time")
)
}
\arguments{
\item{cdata}{data.table of \code{colData}.}

\item{identifiers}{charvec with identifiers}

\item{req_cols}{charvec required columns}
}
\value{
JSON string capturing the \code{cdata}.
}
\description{
Convert colData to JSON format for elasticsearch indexing.
}
\details{
Standardizes the \code{cdata} to common schema fields
and tidies formatting to be condusive to joining
with other JSON responses.
}
\examples{
cdata <- data.table::data.table(
  mycellline = letters, 
  mycelllinename = letters, 
  mycelllinetissue = letters,
  cellline_ref_div_time = "cellline_ref_div_time")
identifiers <- list(cellline = "mycellline",
                    cellline_name = "mycelllinename",
                    cellline_ref_div_time = "cellline_ref_div_time",
                    cellline_tissue = "mycelllinetissue")
convert_colData_to_json(cdata, identifiers)

}
\keyword{json_convert}
