% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterBAMtx.R
\name{filterBAMtx}
\alias{filterBAMtx}
\alias{filterBAMtxFlag}
\alias{testBAMtxFlag}
\title{Filter alignments in a BAM file using a transcriptome}
\usage{
filterBAMtx(
  object,
  path = ".",
  txflag = filterBAMtxFlag(),
  param = ScanBamParam(),
  yieldSize = 1e+06,
  wsize = 1000,
  wstep = 100,
  pstrness = 0.6,
  p.value = 0.05,
  p.adj.method = p.adjust.methods,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

filterBAMtxFlag(
  isSpliceCompatibleJunction = FALSE,
  isSpliceCompatibleExonic = FALSE,
  isInStrandedWindow = FALSE,
  isIntronic = FALSE,
  isIntergenic = FALSE
)

testBAMtxFlag(flag, value)
}
\arguments{
\item{object}{gDNAx object obtained with the function 'gDNAdx()'.}

\item{path}{Directory where to write the output BAM files.}

\item{txflag}{A value from a call to the function 'filterBAMtxFlag()'.}

\item{param}{A 'ScanBamParam' object.}

\item{yieldSize}{(Default 1e6) Number of records in the input BAM file to
yield each time the file is read. The lower the value, the smaller memory
consumption, but in the case of large BAM files, values below 1e6 records
may decrease the overall performance.}

\item{wsize}{(Default 1000) Window size employed when the argument
\code{txflag} includes the value \code{isInStrandedWindow=TRUE}.}

\item{wstep}{(Default 100) Window step employed when the argument
\code{txflag} includes the value \code{isInStrandedWindow=TRUE}.}

\item{pstrness}{(Default 0.6) Strandedness value above which we consider
a target read alignment to occur in stranded window.}

\item{p.value}{(Default 0.05) Numeric value between 0 and 1 specifying the
adjusted p-value cutoff under which we reject the null hypothesis that a
target read alignment occurs in a window with an strandedness value below
the one given in the parameter \code{pstrness}. This parameter is only used
when the argument \code{txflag} includes the value
\code{isInStrandedWindow=TRUE}.}

\item{p.adj.method}{(Default "holm") Method used to adjust p-values that
are compared against the cutoff value specified in the parameter
\code{p.value}. Adjusted p-values are calculated using the base R function
\code{p.adjust()} and this argument is directly passed to the argument
\code{method} of that function.}

\item{verbose}{(Default TRUE) Logical value indicating if progress should be
reported through the execution of the code.}

\item{BPPARAM}{An object of a
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}} subclass
to configure the parallel execution of the code. By default, a
\code{\link[BiocParallel:SerialParam-class]{SerialParam}} object is used, which does
not use any parallelization, with the flag \code{progress=TRUE} to show
progress through the calculations.}

\item{isSpliceCompatibleJunction}{(Default FALSE) Logical value indicating
if spliced alignments overlapping a transcript in a
"splice compatible" way should be included in the BAM file. For
paired-end reads, one or both alignments must have one or more splice
sites compatible with splicing. See
\code{\link[GenomicAlignments:OverlapEncodings-class]{OverlapEncodings}}.}

\item{isSpliceCompatibleExonic}{(Default FALSE) Logical value indicating
if alignments without a splice site, but that overlap a transcript
in a "splice compatible" way, should be included in the BAM file.
For paired-end reads, none of the alignments must be spliced, and
each pair can be in different exons (or in the same one), as long as
they are "splice compatible". See
\code{\link[GenomicAlignments:OverlapEncodings-class]{OverlapEncodings}}.}

\item{isInStrandedWindow}{(Default FALSE) Logical value
indicating whether an alignment occurs in a stranded windows. More
concretely, for each alignment, strandedness will be tested with
respect to the rest of the alignments occurring in overlapping
windows. This filter will assign a TRUE value when those tests are
passed.}

\item{isIntronic}{(Default FALSE) Logical value indicating if alignments
mapping to introns should be included in the BAM file.}

\item{isIntergenic}{(Default FALSE) Logical value indicating if alignments
aligned to intergenic regions should be included in the BAM file.}

\item{flag}{A value from a call to the function 'filterBAMtxFlag()'.}

\item{value}{A character vector with the name of a flag.}
}
\value{
A vector of output filename paths.
}
\description{
Filter alignments in a BAM file using criteria based on a
transcriptome annotation.

Use 'filterBAMtxFlag()' to set what types of alignment in a BAM
file should be filtered using the function 'filterBAMtx()',
among being splice-compatible with one or more exon-exon junctions,
splice-compatible exonic, splice-compatible exonic in a window, intronic or
intergenic.
}
\examples{
library(gDNAinRNAseqData)

library(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene

# Getting the 'gDNAx' object
bamfiles <- LiYu22subsetBAMfiles()
bamfiles <- bamfiles[c(1,7)] # using a subset of samples
gdnax <- gDNAdx(bamfiles, txdb, singleEnd=FALSE, strandMode=NA)

# Filtering splice-compatible alignments and writing them into new BAM files
fbf <- filterBAMtxFlag(isSpliceCompatibleJunction=TRUE,
                       isSpliceCompatibleExonic=TRUE)
dir <- tempdir()
fstats <- filterBAMtx(gdnax, path=dir, txflag=fbf)
list.files(dir, pattern="*.bam$")


# Filtering splice-compatible alignments and writing them into new BAM files
fbf <- filterBAMtxFlag(isSpliceCompatibleJunction=FALSE,
                       isSpliceCompatibleExonic=FALSE,
                       isInStrandedWindow=FALSE,
                       isIntronic=FALSE,
                       isIntergenic=FALSE)

testBAMtxFlag(fbf, "isSpliceCompatibleJunction")
                       
}
