% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateReports.R
\name{ct.makeQCReport}
\alias{ct.makeQCReport}
\title{Generate a QC report from a pooled CRISPR screen}
\usage{
ct.makeQCReport(
  eset,
  trim,
  log2.ratio,
  sampleKey,
  annotation,
  aln,
  identifier = NULL,
  lib.size,
  geneSymb = NULL,
  outdir = NULL
)
}
\arguments{
\item{eset}{An ExpressionSet object containing, at minimum, a matrix of gRNA
abundances extractable with the \code{exprs()} function and some named 
phenodata extractable with \code{pData()}.}

\item{trim}{The number of gRNAs to be trimmed from the top of the 
distribution before estimating the abundance range. Empirically, this 
usually should be equal to about 2 to 5 percent of the guides in the 
library.}

\item{log2.ratio}{Maximum abundance of contaminant gRNAs, expressed on the
log2 scale from the top of the trimmed range of each sample. That is,
\code{log2.ratio = 4} means to discard all gRNAs whose abundance is
(1/2)^4 of the trimmed maximum.}

\item{sampleKey}{A sample key, supplied as an ordered factor linking the 
samples to experimental variables. The \code{names} attribute should 
exactly match those present in \code{eset}, and the control set is assumed
to be the first \code{level}.}

\item{annotation}{An annotation object for the experiment. See the man page 
for \code{ct.prepareAnnotation} for details and example format.}

\item{aln}{A numeric alignment matrix, where rows correspond to 'targets', 
'nomatch', 'rejections', and 'double_match', and where columns correspond 
to experimentasl samples. May be `NULL`, to suppress alignment evaluation.}

\item{identifier}{A character string to name the report and corresponding 
subdirectories. If provided, the final report will be called 
'\code{identifier}.html' and will be located in a directory called 
\code{identifier}. If \code{NULL}, a generic name including the timestamp 
will be generated.}

\item{lib.size}{An optional vector of voom-appropriate library size adjustment factors, usually calculated with \code{\link[edgeR]{calcNormFactors}} 
and transformed to reflect the appropriate library size. These adjustment factors are interpreted as the total library sizes for each sample, 
and if absent will be extrapolated from the columnwise count sums of the \code{exprs} slot of the \code{eset}.}

\item{geneSymb}{The \code{geneSymbol} identifier(s) in \code{annotation} 
that corresponds to gRNAs to be plotted on the curves. Passed through to 
\code{\link{ct.gRNARankByReplicate}}, \code{\link{ct.viewControls}} and 
\code{\link{ct.prepareAnnotation}} (as \code{controls} argument if it's
not \code{NULL}). Default \code{NULL}.}

\item{outdir}{An optional character string indicating the directory in which
to generate the report. If \code{NULL}, a temporary directory will be
automatically generated.}
}
\value{
The path to the generated html report.
}
\description{
This is a function to generate an html QC report for a CRISPR 
  screen, focusing on experiment-level and library-level analyses collected 
  from other functions in \code{gCrisprTools}. It is designed to be used 
  'as-is', and analysts interested in using different functionalities of the
  various functions should do that outside of this wrapper script.
}
\examples{
data('es')
data('ann')
data('aln')

##' #Build the sample key
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))

path2report <- ct.makeQCReport(es, trim = 1000, log2.ratio = 0.0625, sk, ann, aln, identifier = NULL, lib.size = NULL, geneSymb = 'NoTarget', outdir = '.') 
}
\author{
Russell Bainer, Dariusz Ratman
}
