% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.keyCheck}
\alias{ct.keyCheck}
\title{Check compatibility of a sample key with a supplied ExpressionSet or similar object}
\usage{
ct.keyCheck(sampleKey, object)
}
\arguments{
\item{sampleKey}{A named factor, where the \code{levels} indicate the experimental replicate 
groups and the \code{names} match the \code{colnames} of the expression matrix contained in \code{object}. 
The first \code{level} should correspond to the control samples, but obviously there is no 
way to algorithmically control this.}

\item{object}{An \code{ExpressionSet}, \code{EList}, or other matrix-like object with defined `colnames()`.}
}
\value{
Invisibly, a properly formatted `sampleKey`.
}
\description{
For many gCrisprTools functions, a sample key must be provided that specifies 
sample mapping to experimental groups. The sample key should be provided as a single, named factor whose  
names exactly correspond to the `colnames()` of the `ExpressionSet` containing the count data to be 
processed (or coercible as such). By convention, the first level corresponds to the control sample group.
 
This function checks whether the specified sample key is of the proper format and has 
properties consistent with the specified object.
}
\examples{
data('es')
library(limma)
library(Biobase)

#Build the sample key
sk <- relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference')
names(sk) <- row.names(pData(es))
ct.keyCheck(sk, es)
}
\author{
Russell Bainer
}
