% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.inputCheck}
\alias{ct.inputCheck}
\title{Check compatibility of a sample key with a supplied object}
\usage{
ct.inputCheck(sampleKey, object)
}
\arguments{
\item{sampleKey}{A named factor, where the \code{levels} indicate the experimental replicate 
groups and the \code{names} match the \code{colnames} of the expression matrix contained in \code{object}. 
The first \code{level} should correspond to the control samples, but obviously there is no 
way to algorithmically control this.}

\item{object}{An \code{ExpressionSet}, \code{EList}, or matrix.}
}
\value{
A logical indicating whether the objects are compatible.
}
\description{
For many gCrisprTools functions, a sample key must be provided that specifies 
sample mapping to experimental groups. The sample key should be provided as a single, named factor whose  
names exactly correspond to the `colnames()` of the `ExpressionSet` containing the count data to be 
processed (or coercible as such). By convention, the first level corresponds to the control sample group.
 
This function checks whether the specified sample key is of the proper format and has 
properties consistent with the specified object.
}
\author{
Russell Bainer
}
