% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.buildSE}
\alias{ct.buildSE}
\title{Package Screen Data into a `SummarizedExperiment` Object}
\usage{
ct.buildSE(
  es,
  sampleKey = NULL,
  ann = NULL,
  vm = NULL,
  fit = NULL,
  summaryList = NULL
)
}
\arguments{
\item{es}{An `ExpressionSet` of screen data. Required.}

\item{sampleKey}{a gCrisprTools `sampleKey` object, to be added to the `colData`.}

\item{ann}{Annotation object to be packaged into the `rowData`}

\item{vm}{A `voom`-derived normalized object}

\item{fit}{a `MArrayLM` object containing the contrast information and model results}

\item{summaryList}{A named list of \code{data.frame}s, returned by \code{ct.generateResults}. 
if you need to generate one of these by hand for some reason, see the example 
\code{resultsDF} object loaded in the example below.}
}
\value{
A `SummarizedExperiment` object.
}
\description{
Convenience function to package major components of a screen into a `SummarizedExperiment` container
for downstream visualization and analysis. All arguments are optional except for `es`.
}
\examples{
data('ann', 'es', 'fit', 'resultsDF')
ct.buildSE(es, ann = ann, fit = 'fit', summaryList = list('resA' = resultsDF, 'resB' = resultsDF))
}
\author{
Russell Bainer
}
