% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRAalpha.R
\name{ct.alphaBeta}
\alias{ct.alphaBeta}
\title{Aggregation of P-value Ranks using a Beta Distribution and Alpha Cutoff}
\usage{
ct.alphaBeta(p.in)
}
\arguments{
\item{p.in}{A single column matrix of rank scores, with row.names indicating the gRNA labels.}
}
\value{
A numeric rho value corresponding to the minimum rank order P.
}
\description{
This function calculates an alpha-modified rho statistic from a set of normalized ranks by comparing them to a uniform distribution. 
Specifically, the ranks are ordered and p-values calculated at each position in the ordered vector by comparison to a Beta distribution. The rho value 
returned is the smallest p-value identified in this way across all scores. Should not be used by end users.
}
\examples{
testp <- runif(20)

ct.alphaBeta(testp)  
}
\author{
Russell Bainer, modified from code from the \code{RobustRankAggreg} package. 

Citation: 
Kolde, R. et al, Bioinformatics. 2012 Feb 15;28(4):573-80. doi: 10.1093/bioinformatics/btr709.
}
\keyword{internal}
