% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCbias.R
\name{ct.GCbias}
\alias{ct.GCbias}
\title{Visualization of gRNA GC Content Trends}
\usage{
ct.GCbias(data.obj, ann, sampleKey = NULL, lib.size = NULL)
}
\arguments{
\item{data.obj}{An \code{ExpressionSet} or fit (\code{MArrayLM}) object to be analyzed for the presence of GC 
content bias.}

\item{ann}{An annotation \code{data.frame}, used to estimate GC content for each guide. Guides are annotated by 
row, and the object must minimally contain a \code{target} column containing a character 
vector that indicates the corresponding nucleotide sequences.}

\item{sampleKey}{An optional sample key, supplied as a factor linking the samples to experimental 
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the 
control set is assumed to be the first \code{level}. Ignored in the analysis of model fit objects.}

\item{lib.size}{An optional vector of voom-appropriate library size adjustment factors, usually calculated with \code{\link[edgeR]{calcNormFactors}} 
and transformed to reflect the appropriate library size. These adjustment factors are interpreted as the total library sizes for each sample, 
and if absent will be extrapolated from the columnwise count sums of the \code{exprs} slot of the \code{eset}.}
}
\value{
An image relating GC content to experimental observations on the default device. If the 
provided \code{data.obj} is an \code{ExpressionSet}, this takes the form of a scatter plot where the 
GC% and abundance estimates of each guide are represented as points overlaid
with a smoothed trendline within each sample. If \code{data.obj} is a fit object describing a linear model 
contrast, then four panels are returned describing the GC content distribution and its relationship 
to guide-level fold change, standard deviation, and P-value estimates.
}
\description{
This function visualizes relationships between gRNA GC content and their measured abundance or 
various differential expression model estimates.
}
\examples{
data('es')
data('ann')
data('fit')

ct.GCbias(es, ann)
ct.GCbias(fit, ann)
}
\author{
Russell Bainer
}
