% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{read.Frames}
\alias{read.Frames}
\title{Constructor for a \code{Frames} object}
\usage{
read.Frames(image.files, nframes = NULL)
}
\arguments{
\item{image.files}{Vector of strings containing the locations where the (raw) images are to be found, or alternatively, the path to the folder}

\item{nframes}{Number of frames that will constitute the \code{Frames} object}
}
\value{
An object of the \code{Frames} class, which holds the info on a list of frames, specifying for each the following elements:
\item{image}{The \code{Image} object containing the image itself}
\item{location}{The complete path to the location of the original image}
}
\description{
This function is used to create a \code{Frames} object from a vector of image files (or a folder specifying the directory
containing them).
The number of frames is also specified, as just a subset of the images can be used for this
}
\examples{
## see vignette
\dontrun{fullData <- read.Frames(image.files = "/path/to/the/directory", nframes = 100)}

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
