% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_gs.R
\name{save_gs}
\alias{save_gs}
\alias{load_gs}
\alias{save_gslist}
\alias{load_gslist}
\alias{sampleNames,character-method}
\title{save/load a GatingSet/GatingSetList to/from disk.}
\usage{
save_gs(
  gs,
  path,
  cdf = NULL,
  backend_opt = c("copy", "move", "skip", "symlink", "link"),
  ...
)

load_gs(
  path,
  h5_readonly = NULL,
  backend_readonly = TRUE,
  select = character(),
  verbose = FALSE
)

\S4method{sampleNames}{character}(object)

save_gslist(gslist, path, ...)

load_gslist(path)
}
\arguments{
\item{gs}{A \code{GatingSet}}

\item{path}{A character scalar giving the path to save/load the GatingSet to/from.}

\item{backend_opt}{a character scalar. The valid options are :"copy","move","skip","symlink" specifying what to do with the backend data file.
Sometimes it is more efficient to move or create a symlink of the existing backend file to the archived folder.
It is useful to "skip" archiving backend file if raw data has not been changed.}

\item{...}{other arguments: not used.}

\item{h5_readonly}{whether to open h5 data as read-only. Default is TRUE}

\item{select}{an integer or character vector to select a subset of samples to load}

\item{verbose}{logical flag to optionally print the versions of the libraries that were used to archive the GatingSet for troubleshooting purpose.}

\item{object}{a \code{GatingSet} folder}

\item{gslist}{A \code{GatingSetList}}
}
\description{
Save/load a GatingSet/GatingSetList which is the gated flow data including gates and populations to/from the disk.
The \code{GatingSet} object The internal C data structure (gating tree),\code{ncdfFlowSet} object(if applicable)

Retrieve  sample names by scanning h5 files from a GatingSet folder
}
\examples{
\dontrun{
	#G is a GatingSet
	save_gs(G,path="tempFolder")
	G1<-load_gs(path="tempFolder")

	#G is a GatingSet

	save_gslist(gslist1,path="tempFolder")
	gslist2<-load_gslist(path="tempFolder")
}
      \dontrun{
        sampleNames(gsdir)
      }
}
\seealso{
\code{\link{GatingSet-class}},\code{\link{GatingSetList-class}}
}
