% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovtsub.R
\name{overton_like}
\alias{overton_like}
\title{Overton-like subtraction of densities.}
\usage{
overton_like(ref, test, twosided = FALSE)
}
\arguments{
\item{ref}{The reference channel specified as a \code{vector}}

\item{test}{The test (potentially positive) channel specified as a \code{vector}}

\item{twosided}{\code{boolean} flag testing whether the area of the density of the test curve above the reference curve will be calculated on both sides of the mode of the test curve (TRUE) or only on the positive side of the mode (FALSE, default).}
}
\value{
\code{numeric} value representing the proportion of the area of the test density above the reference density.
}
\description{
This function computes an Overton-like subtraction of two densities. It calculates the proportion of the reference density that is above a reference
}
\details{
The test can be one-sided or two-sided. If one sided, it tests the region of the test density that is above the mode of the reference density. If two-sided it will look at the regions on either side of the mode of the reference density.
Densities are computed on a grid of 1024, and appropriately normalized.
}
\examples{
A = rnorm(10000,mean=1,sd=0.5)
B = rnorm(10000,mean=2,sd=0.5)
overton_like(A,B)

}
\author{
Greg Finak
}
